% Model of a steady state isothermal plug flow reactor - Gas phase

% Function file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

function dndW = f(W,n,k2,KE,KH,KA,ME,MH,MA,OMEGA,mu,Temp,dp,rhob,phi)

dndW = zeros(4,1);     % Allocate space for the right-hand sides of the DEs

p = n(4);              % Pressure in Pa
pbar = p/1e5;          % Pressure in bar
nE = n(1);             % Molar flow rates (mol/s)
nH = n(2);
nA = n(3);
ntot = nE + nH + nA;   % Total flow rate (mol/s)
R = 8.314472;          % Ideal gas constant (J/mol K)
yE = nE/ntot;          % Mole fraction of E
yH = nH/ntot;          % Mole fraction of hydrogen
yA = nA/ntot;          % Mole fraction of A
pE = pbar*yE;          % Partial pressures (bar)
pH = pbar*yH;
pA = pbar*yA;
G = (nE*ME + nH*MH + nA*MA)/OMEGA;   % Mass flus (kg/m2/s)
rho = (p/(R*Temp))*(ME*yE + MH*yH + MA*yA);  % Gas density (kg/m3)

r = k2*pE*sqrt(pH)/(1 + KE*pE + sqrt(KH*pH) + KA*pA)^2; % Reaction rate

dpdz = -(G/(rho*dp))*((1 - phi)/phi^3)*(150*(1 - phi)*mu/dp + 1.75*G);
dzdW = 1/(OMEGA*rhob);

dndW(1) = -r;          % Differential equations
dndW(2) = -r;
dndW(3) = r;
dndW(4) = dpdz*dzdW;
